dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 8, 220, 310, "assets/images/table/ballroom_8", "assets/images/food/item_mark3", "R" );


useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 20000);

-- Group 3

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 7, 44000);


-- Group 4

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 9, 60000);

-- Group 5

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 10, 70000);


-- Group 6

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 13, 95000);

-- Group 7

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 120000);


LManager:AdjustGuestTolerance(130);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 80000 );

LManager:SetLevelSetting ("speakerDelay", 110000); 
LManager:SetLevelSetting ("speakerChance", 30);

-- Set up the Level Settings
LManager:SetLevelNumber(2,6);
LManager:SetLevelScores(5800, 8600);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_1.ogg","assets/audio/music/uptempo_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );